/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

public enum ParamOption {
    clean("Delete previous computations"),
    n("Just print process information, but do not execute it"),
    color("Colorize console log messages"),
    nocolor("Uncolorize console log messages"),
    nice("[MIRROR] Slow download for avoiding to overload remote http server"),
    clone("[MIRROR] Force clone (ignoring \"unclonable\" hips_status)", 1),
    notouch("Do not touch the hips_release_date"),
    hhhcar("[INDEX] Generate hhh file for an all sky image"),
    trim("[TILES,CONCAT,APPEND] Trim FITS tiles if possible"),
    gzip("[TILES,CONCAT,APPEND] Gzip FITS tiles"),
    cds("[LINT] CDS dedicated LINT features", 1),
    d("Debug messages"),
    h("Inline help"),
    man("Full inline man (may be followed by a parameter or an action for a full explanation)"),
    html("HTML output", 1);

    private String info;
    private int m = 0;

    private ParamOption(String info) {
        this.info = info;
    }

    private ParamOption(String info, int m) {
        this.info = info;
        this.m = m;
    }

    String info() {
        return "-" + (Object)((Object)this) + " => " + this.info;
    }

    boolean equals(String s) {
        return ("-" + this.toString().toLowerCase()).equals(s.toLowerCase());
    }

    static String help() {
        StringBuilder s = new StringBuilder();
        for (ParamOption a : ParamOption.values()) {
            if ((a.m & 3) != 0) continue;
            String s1 = String.format("%-7s: ", new Object[]{a});
            s.append("   -" + s1 + a.info + "\n");
        }
        return s.toString();
    }

    class A {
        static final int UNDOC = 1;
        static final int TEST = 2;

        A() {
        }
    }
}

